package de.bebagoe.figuren;

public non-sealed class Quadrat extends Figur {
	protected double seite;
	
	public Quadrat(double x, double y, double s) {
        if (s < 0)
            throw new IllegalArgumentException("Flächeninhalt negativ");
        seite = s;
        super(x, y);
	}
	
	public Quadrat() {
        seite = 50.0;
        super();
    }

    public double getSeite() {
        return seite;
    }

	@Override
	public double abstand(double x, double y) {
		return Math.sqrt(Math.pow(xpos+seite/2-x,2) + Math.pow(ypos+seite/2-y,2));
	}

	@Override
	public void wo() {
		super.wo();
		System.out.println("Unten rechts: (" + (xpos+seite) + ", " + (ypos+seite) + ")");
	}

	@Override
	public double meldeInhalt() {
		return seite * seite;
	}
}


